***********************************************************************
12/13/07: 
***********************************************************************;

*%INCLUDE "~/jim/gzipseq.mcr";
LIBNAME alldat '~/jim/data';

*******  FAMILY FILES   **********;
 
filename mtab841 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0003-Data.txt.gz';
filename mtab842 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0007-Data.txt.gz';
filename mtab843 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0011-Data.txt.gz';
filename mtab844 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0015-Data.txt.gz';

filename mtab851 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0003-Data.txt.gz';
filename mtab852 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0007-Data.txt.gz';
filename mtab853 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0011-Data.txt.gz';
filename mtab854 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0015-Data.txt.gz';
filename mtab855 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0019-Data.txt.gz';

filename mtab861 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0003-Data.txt.gz';
filename mtab862 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0007-Data.txt.gz';
filename mtab863 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0011-Data.txt.gz';
filename mtab864 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0015-Data.txt.gz';

%MACRO read(qyr);
 
  DATA exp&qyr;
   INFILE mtab&qyr ;
   IF &qyr LE 955 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 ref_mo 30-31 ref_yr 32-33;
   IF &qyr GE 961 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 ref_mo 30-31 ref_yr 32-35;
   qyear=&qyr;
   IF qyear LE 855 THEN newid=9000000+newid;
  RUN;
PROC SORT; 
   BY newid;
RUN; 
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN (190904 790220 790230);
     VAR cost;
     OUTPUT OUT=food_hm_dat&qyr(DROP=_TYPE_ _FREQ_) SUM=food_home_adj;
RUN;
PROC MEANS; 
RUN;
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN (190901 190902 190903 790410 800700 790430);
     VAR cost;
     OUTPUT OUT=food_away_dat&qyr(DROP=_TYPE_ _FREQ_) SUM=food_away_adj;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(690242 690245);
     VAR cost;
     OUTPUT OUT=othapl_hmdat&qyr(DROP=_TYPE_ _FREQ_) SUM=oth_apl_hm_adj;
RUN;
PROC MEANS; 
RUN;
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(690241 690244);
     VAR cost;
     OUTPUT OUT=othapl_awaydat&qyr(DROP=_TYPE_ _FREQ_) SUM=oth_apl_away_adj;
RUN;
PROC MEANS; 
RUN;
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(690243);
     VAR cost;
     OUTPUT OUT=othapl_othdat&qyr(DROP=_TYPE_ _FREQ_) SUM=oth_apl_oth_adj;
RUN;
PROC MEANS; 
RUN;

PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     ID qyear;
     WHERE ucc IN(520901 520904 520907 620902 620906 620907);
     VAR cost;
     OUTPUT OUT=boats&qyr(DROP=_TYPE_ _FREQ_) SUM=boats_adj;
RUN;
PROC MEANS; 
RUN;

%MEND read;

%read(841);
%read(842);
%read(843);
%read(844);

%read(851);
%read(852);
%read(853);
%read(854);
%read(855);

%read(861);
%read(862);
%read(863);
%read(864);

DATA temp1;
   SET  food_hm_dat841 food_hm_dat842 food_hm_dat843 food_hm_dat844
        food_hm_dat851 food_hm_dat852 food_hm_dat853 food_hm_dat854 food_hm_dat855
        food_hm_dat861 food_hm_dat862 food_hm_dat863 food_hm_dat864;
RUN;
PROC SORT; 
   BY newid;
RUN; 
DATA temp2;
   SET  food_away_dat841 food_away_dat842 food_away_dat843 food_away_dat844
        food_away_dat851 food_away_dat852 food_away_dat853 food_away_dat854 food_away_dat855
        food_away_dat861 food_away_dat862 food_away_dat863 food_away_dat864;
RUN;
PROC SORT; 
   BY newid;
RUN; 
DATA temp3;
   SET  othapl_hmdat841 othapl_hmdat842 othapl_hmdat843 othapl_hmdat844
        othapl_hmdat851 othapl_hmdat852 othapl_hmdat853 othapl_hmdat854 othapl_hmdat855
        othapl_hmdat861 othapl_hmdat862 othapl_hmdat863 othapl_hmdat864;
RUN;
PROC SORT; 
   BY newid;
RUN; 
DATA temp3b;
   SET  othapl_awaydat841 othapl_awaydat842 othapl_awaydat843 othapl_awaydat844
        othapl_awaydat851 othapl_awaydat852 othapl_awaydat853 othapl_awaydat854 othapl_awaydat855
        othapl_awaydat861 othapl_awaydat862 othapl_awaydat863 othapl_awaydat864;
RUN;
PROC SORT; 
   BY newid;
RUN; 
DATA temp3c;
   SET  othapl_othdat841 othapl_othdat842 othapl_othdat843 othapl_othdat844
        othapl_othdat851 othapl_othdat852 othapl_othdat853 othapl_othdat854 othapl_othdat855
        othapl_othdat861 othapl_othdat862 othapl_othdat863 othapl_othdat864;
RUN;
PROC SORT; 
   BY newid;
RUN; 

DATA temp4;
   SET  boats841 boats842 boats843 boats844
        boats851 boats852 boats853 boats854 boats855
        boats861 boats862 boats863 boats864;
RUN;
PROC SORT; 
   BY newid;
RUN; 

DATA alldat.exp_adj_dat8486;
MERGE temp1 temp2 temp3 temp3b temp3c temp4;
BY newid;
RUN;

PROC MEANS; 
RUN;
*%gzipsq(work,exp_adj_dat8486,~/jim/data); 




